var hasOwn = Object.prototype.hasOwnProperty;
var objToStr = Object.prototype.toString;
var objStr = objToStr.call({});

function isPlainObject(value) {
  return objToStr.call(value) === objStr;
}
exports.isPlainObject = isPlainObject;

exports.assign = Object.assign || function (obj) {
  var argc = arguments.length;
  for (var i = 1; i < argc; ++i) {
    var arg = arguments[i];
    if (arg && typeof arg === "object") {
      var keys = Object.keys(arg);
      for (var k = 0; k < keys.length; ++k) {
        var key = keys[k];
        obj[key] = arg[key];
      }
    }
  }
  return obj;
};

exports.shallowObjEqual = function(a, b) {
  if (a === b) {
    return true;
  }

  if (! isPlainObject(a) ||
      ! isPlainObject(b)) {
    return false;
  }

  var aKeys = Object.keys(a);
  var bKeys = Object.keys(b);

  if (aKeys.length !== bKeys.length) {
    return false;
  }

  return aKeys.every(function (key) {
    return hasOwn.call(b, key) &&
      a[key] === b[key];
  });
};
