# ip-port-regex [![version][npm-version]][npm-url] [![License][npm-license]][license-url]

> Regular expression for matching IP addresses with associated ports

[![Build Status][travis-image]][travis-url]
[![Downloads][npm-downloads]][npm-url]
[![Code Climate][codeclimate-quality]][codeclimate-url]
[![Coverage Status][codeclimate-coverage]][codeclimate-url]
[![Dependencies][david-image]][david-url]

## Install

```sh
npm install --save ip-port-regex
```

## Usage

```js
var ipRegex = require('ip-port-regex');

// contains a valid address
ipRegex().test('unicorn 192.168.0.1:8000');
//=> true

// is a valid address
ipRegex({exact: true}).test('unicorn 192.168.0.1:8001');
//=> false

ipRegex.v6({exact: true}).test('1:2:3:4:5:6:7:8:9000');
//=> true

'unicorn 192.168.0.1:8080 cake 1:2:3:4:5:6:7:8 rainbow'.match(ipRegex());
//=> ['192.168.0.1', '1:2:3:4:5:6:7:8']
```

## API


### ipRegex(options)

Returns a regex for matching both IPv4 and IPv6.

### ipRegex.v4(options)

Returns a regex for matching IPv4.

### ipRegex.v6(options)

Returns a regex for matching IPv6.

### ipRegex.parts(string)

Returns an Object, containing found IP address + Port in `string`

#### options.exact

Type: `boolean`  
Default: `false` *(Matches any IP address in a string)*

Only match an exact string.  
Useful with `RegExp#test` to check if a string is an IP address.

## Support

Donations are welcome to help support the continuous development of this project.

[![Gratipay][gratipay-image]][gratipay-url]
[![PayPal][paypal-image]][paypal-url]
[![Flattr][flattr-image]][flattr-url]
[![Bitcoin][bitcoin-image]][bitcoin-url]

## License

[MIT](LICENSE) &copy; [Ahmad Nassri](https://www.ahmadnassri.com)

[license-url]: https://github.com/ahmadnassri/ip-port-regex/blob/master/LICENSE

[travis-url]: https://travis-ci.org/ahmadnassri/ip-port-regex
[travis-image]: https://img.shields.io/travis/ahmadnassri/ip-port-regex.svg?style=flat-square

[npm-url]: https://www.npmjs.com/package/ip-port-regex
[npm-license]: https://img.shields.io/npm/l/ip-port-regex.svg?style=flat-square
[npm-version]: https://img.shields.io/npm/v/ip-port-regex.svg?style=flat-square
[npm-downloads]: https://img.shields.io/npm/dm/ip-port-regex.svg?style=flat-square

[codeclimate-url]: https://codeclimate.com/github/ahmadnassri/ip-port-regex
[codeclimate-quality]: https://img.shields.io/codeclimate/github/ahmadnassri/ip-port-regex.svg?style=flat-square
[codeclimate-coverage]: https://img.shields.io/codeclimate/coverage/github/ahmadnassri/ip-port-regex.svg?style=flat-square

[david-url]: https://david-dm.org/ahmadnassri/ip-port-regex
[david-image]: https://img.shields.io/david/ahmadnassri/ip-port-regex.svg?style=flat-square

[gratipay-url]: https://www.gratipay.com/ahmadnassri/
[gratipay-image]: https://img.shields.io/gratipay/ahmadnassri.svg?style=flat-square

[paypal-url]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=UJ2B2BTK9VLRS&on0=project&os0=ip-port-regex
[paypal-image]: http://img.shields.io/badge/paypal-donate-green.svg?style=flat-square

[flattr-url]: https://flattr.com/submit/auto?user_id=ahmadnassri&url=https://github.com/ahmadnassri/ip-port-regex&title=ip-port-regex&language=&tags=github&category=software
[flattr-image]: http://img.shields.io/badge/flattr-donate-green.svg?style=flat-square

[bitcoin-image]: http://img.shields.io/badge/bitcoin-1Nb46sZRVG3or7pNaDjthcGJpWhvoPpCxy-green.svg?style=flat-square
[bitcoin-url]: https://www.coinbase.com/checkouts/ae383ae6bb931a2fa5ad11cec115191e?name=ip-port-regex
