"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("@oozcitak/util");
/**
 * Flattens the given options argument.
 *
 * @param options - options argument
 */
function eventTarget_flatten(options) {
    if (util_1.isBoolean(options)) {
        return options;
    }
    else {
        return options.capture || false;
    }
}
exports.eventTarget_flatten = eventTarget_flatten;
/**
 * Flattens the given options argument.
 *
 * @param options - options argument
 */
function eventTarget_flattenMore(options) {
    const capture = eventTarget_flatten(options);
    let once = false;
    let passive = false;
    if (!util_1.isBoolean(options)) {
        once = options.once || false;
        passive = options.passive || false;
    }
    return [capture, passive, once];
}
exports.eventTarget_flattenMore = eventTarget_flattenMore;
/**
 * Adds a new event listener.
 *
 * @param eventTarget - event target
 * @param listener - event listener
 */
function eventTarget_addEventListener(eventTarget, listener) {
    if (listener.callback === null)
        return;
    // return if the listener is already defined
    for (let i = 0; i < eventTarget._eventListenerList.length; i++) {
        const entry = eventTarget._eventListenerList[i];
        if (entry.type === listener.type && entry.callback === listener.callback
            && entry.capture === listener.capture) {
            return;
        }
    }
    // add to listener list
    eventTarget._eventListenerList.push(listener);
}
exports.eventTarget_addEventListener = eventTarget_addEventListener;
/**
 * Removes an event listener.
 *
 * @param eventTarget - event target
 * @param listener - event listener
 */
function eventTarget_removeEventListener(eventTarget, listener, index = -1) {
    listener.removed = true;
    // check if the listener is defined
    if (index === -1) {
        for (let i = 0; i < eventTarget._eventListenerList.length; i++) {
            const entry = eventTarget._eventListenerList[i];
            if (entry.type === listener.type && entry.callback === listener.callback
                && entry.capture === listener.capture) {
                index = i;
                break;
            }
        }
    }
    // remove from list
    if (index !== -1) {
        eventTarget._eventListenerList.splice(index, 1);
    }
}
exports.eventTarget_removeEventListener = eventTarget_removeEventListener;
/**
 * Removes all event listeners.
 *
 * @param eventTarget - event target
 */
function eventTarget_removeAllEventListeners(eventTarget) {
    // check if the listener is defined
    for (const e of eventTarget._eventListenerList) {
        e.removed = true;
    }
    // empty list
    eventTarget._eventListenerList = [];
}
exports.eventTarget_removeAllEventListeners = eventTarget_removeAllEventListeners;
//# sourceMappingURL=EventTargetAlgorithm.js.map