"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const XMLSerializerNSImpl_1 = require("./XMLSerializerNSImpl");
const XMLSerializerNoNSImpl_1 = require("./XMLSerializerNoNSImpl");
/**
 * Represents an XML serializer.
 *
 * Implements: https://www.w3.org/TR/DOM-Parsing/#serializing
 */
class XMLSerializerImpl {
    /** @inheritdoc */
    serializeToString(root) {
        // To increase performance, use a namespace-aware serializer only if the
        // document has namespaced elements
        if (root._nodeDocument === undefined || root._nodeDocument._hasNamespaces) {
            return new XMLSerializerNSImpl_1.XMLSerializerNSImpl().serializeToString(root);
        }
        else {
            return new XMLSerializerNoNSImpl_1.XMLSerializerNoNSImpl().serializeToString(root);
        }
    }
}
exports.XMLSerializerImpl = XMLSerializerImpl;
//# sourceMappingURL=XMLSerializerImpl.js.map